<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')

    <div class="form-group {{ $errors->has('circle.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.circle.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="circle.name">
        <div class="validation-message">
            {{ $errors->first('circle.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.circle.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('circle.is_active') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="is_active" id="is_active" wire:model.defer="circle.is_active">
        <label class="form-label inline ml-1" for="is_active">{{ trans('cruds.circle.fields.is_active') }}</label>
        <div class="validation-message">
            {{ $errors->first('circle.is_active') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.circle.fields.is_active_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('circle.zone_id') ? 'invalid' : '' }}">
        <label class="form-label" for="zone">{{ trans('cruds.circle.fields.zone') }}</label>
        <x-select-list class="form-control" id="zone" name="zone" :options="$this->listsForFields['zones']" wire:model="circle.zone_id" />
        <div class="validation-message">
            {{ $errors->first('circle.zone_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.circle.fields.zone_helper') }}
        </div>
    </div>
    {{-- <div class="form-group {{ $errors->has('circle.state_id') ? 'invalid' : '' }}">
        <label class="form-label" for="state">{{ trans('cruds.circle.fields.state') }}</label>
        <x-select-list class="form-control" id="state" name="state" :options="$this->listsForFields['state']" wire:model="circle.state_id" />
        <div class="validation-message">
            {{ $errors->first('circle.state_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.circle.fields.state_helper') }}
        </div>
    </div> --}}

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.circles.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
