<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('circle_product_pivot_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="CircleProductPivot" format="csv" />
                <livewire:excel-export model="CircleProductPivot" format="xlsx" />
                <livewire:excel-export model="CircleProductPivot" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.circleProductPivot.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.circleProductPivot.fields.product') }}
                            @include('components.table.sort', ['field' => 'product.name'])
                        </th>
                        <th>
                            {{ trans('cruds.circleProductPivot.fields.circle') }}
                            @include('components.table.sort', ['field' => 'circle.name'])
                        </th>
                        <th>
                            {{ trans('cruds.circleProductPivot.fields.quantity') }}
                            @include('components.table.sort', ['field' => 'quantity'])
                        </th>
                        <th>
                            {{ trans('cruds.circleProductPivot.fields.price') }}
                            @include('components.table.sort', ['field' => 'price'])
                        </th>
                        <th>
                            {{ trans('cruds.circleProductPivot.fields.last_updated_by') }}
                            @include('components.table.sort', ['field' => 'last_updated_by.name'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($circleProductPivots as $circleProductPivot)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $circleProductPivot->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $circleProductPivot->id }}
                            </td>
                            <td>
                                @if($circleProductPivot->product)
                                    <span class="badge badge-relationship">{{ $circleProductPivot->product->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($circleProductPivot->circle)
                                    <span class="badge badge-relationship">{{ $circleProductPivot->circle->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $circleProductPivot->quantity }}
                            </td>
                            <td>
                                {{ $circleProductPivot->price }}
                            </td>
                            <td>
                                @if($circleProductPivot->lastUpdatedBy)
                                    <span class="badge badge-relationship">{{ $circleProductPivot->lastUpdatedBy->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('circle_product_pivot_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.circle-product-pivots.show', $circleProductPivot) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('circle_product_pivot_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.circle-product-pivots.edit', $circleProductPivot) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('circle_product_pivot_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $circleProductPivot->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $circleProductPivots->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush