<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('circleProductPivot.product_id') ? 'invalid' : '' }}">
        <label class="form-label" for="product">{{ trans('cruds.circleProductPivot.fields.product') }}</label>
        <x-select-list class="form-control" id="product" name="product" :options="$this->listsForFields['product']" wire:model="circleProductPivot.product_id" />
        <div class="validation-message">
            {{ $errors->first('circleProductPivot.product_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.circleProductPivot.fields.product_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('circleProductPivot.circle_id') ? 'invalid' : '' }}">
        <label class="form-label" for="circle">{{ trans('cruds.circleProductPivot.fields.circle') }}</label>
        <x-select-list class="form-control" id="circle" name="circle" :options="$this->listsForFields['circle']" wire:model="circleProductPivot.circle_id" />
        <div class="validation-message">
            {{ $errors->first('circleProductPivot.circle_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.circleProductPivot.fields.circle_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('circleProductPivot.quantity') ? 'invalid' : '' }}">
        <label class="form-label" for="quantity">{{ trans('cruds.circleProductPivot.fields.quantity') }}</label>
        <input class="form-control" type="number" name="quantity" id="quantity" wire:model.defer="circleProductPivot.quantity" step="1">
        <div class="validation-message">
            {{ $errors->first('circleProductPivot.quantity') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.circleProductPivot.fields.quantity_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('circleProductPivot.price') ? 'invalid' : '' }}">
        <label class="form-label" for="price">{{ trans('cruds.circleProductPivot.fields.price') }}</label>
        <input class="form-control" type="number" name="price" id="price" wire:model.defer="circleProductPivot.price" step="0.01">
        <div class="validation-message">
            {{ $errors->first('circleProductPivot.price') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.circleProductPivot.fields.price_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('circleProductPivot.last_updated_by_id') ? 'invalid' : '' }}">
        <label class="form-label" for="last_updated_by">{{ trans('cruds.circleProductPivot.fields.last_updated_by') }}</label>
        <x-select-list class="form-control" id="last_updated_by" name="last_updated_by" :options="$this->listsForFields['last_updated_by']" wire:model="circleProductPivot.last_updated_by_id" />
        <div class="validation-message">
            {{ $errors->first('circleProductPivot.last_updated_by_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.circleProductPivot.fields.last_updated_by_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.circle-product-pivots.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>