<div>

    {{-- @fjson($filters) --}}

    <div class=" px-2 ">
        <label class="form-label required" for="circles">Filter by Circles</label>
        <x-tags-list class="form-control" required id="circles" name="circles" wire:model="selected_circle_ids"
            :options="$this->listsForFields['circles']" multiple />
    </div>
    <div class=" px-2 ">
        <label class="form-label required" for="client_branches">Filter by Branches</label>
        <x-tags-list class="form-control" required id="client_branches" name="client_branches"
            wire:model="selected_branch_ids" :options="$this->listsForFields['client_branches']" multiple />
    </div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach ($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('task_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button"
                    wire:click="confirm('deleteSelected')" wire:loading.attr="disabled"
                    {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if (file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="Task" format="csv" />
                <livewire:excel-export model="Task" format="xlsx" />
                <livewire:excel-export model="Task" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>

    @include('components.loading-spinner-full-page')


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.task.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.task.fields.name') }}
                            @include('components.table.sort', ['field' => 'name'])
                        </th>
                        <th>
                            {{ trans('cruds.task.fields.description') }}
                            @include('components.table.sort', ['field' => 'description'])
                        </th>
                        <th>
                            {{ trans('cruds.task.fields.status') }}
                            @include('components.table.sort', ['field' => 'status.name'])
                        </th>
                        <th>
                            Issued At
                            @include('components.table.sort', ['field' => 'created_at'])
                        </th>
                        {{-- <th>
                            {{ trans('cruds.task.fields.tag') }}
                        </th>
                        <th>
                            {{ trans('cruds.task.fields.attachment') }}
                        </th>
                        <th>
                            {{ trans('cruds.task.fields.due_date') }}
                            @include('components.table.sort', ['field' => 'due_date'])
                        </th>
                        <th>
                            {{ trans('cruds.task.fields.assigned_to') }}
                            @include('components.table.sort', ['field' => 'assigned_to.name'])
                        </th>
                        <th>
                            {{ trans('cruds.task.fields.client_group') }}
                            @include('components.table.sort', ['field' => 'client_group.name'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.business_name') }}
                            @include('components.table.sort', ['field' => 'client_group.business_name'])
                        </th>
                        <th>
                            {{ trans('cruds.task.fields.client') }}
                            @include('components.table.sort', ['field' => 'client.name'])
                        </th> --}}
                        <th>
                            {{ trans('cruds.task.fields.client_branch') }}
                            @include('components.table.sort', ['field' => 'client_branch.name'])
                        </th>
                        {{-- <th>
                            {{ trans('cruds.task.fields.call_type') }}
                            @include('components.table.sort', ['field' => 'call_type'])
                        </th>
                        <th>
                            {{ trans('cruds.task.fields.incode') }}
                            @include('components.table.sort', ['field' => 'incode'])
                        </th> --}}
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($tasks as $task)
                        <tr>
                            <td>
                                {{-- <input type="checkbox" value="{{ $task->id }}" wire:model="selected"> --}}
                            </td>
                            <td>
                                {{ $task->id }}
                            </td>
                            <td>
                                {{ $task->name }}
                            </td>
                            <td>
                                {{ $task->description }}
                            </td>
                            <td>
                                @if ($task->status)
                                    <span class="badge badge-relationship">{{ $task->status->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $task->created_at }}
                            </td>
                            {{-- <td>
                                @foreach ($task->tag as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                            <td>
                                @foreach ($task->attachment as $key => $entry)
                                    <a class="link-light-blue" href="{{ $entry['url'] }}">
                                        <i class="far fa-file">
                                        </i>
                                        {{ $entry['file_name'] }}
                                    </a>
                                @endforeach
                            </td>
                            <td>
                                {{ $task->due_date }}
                            </td>
                            <td>
                                @if ($task->assignedTo)
                                    <span class="badge badge-relationship">{{ $task->assignedTo->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if ($task->clientGroup)
                                    <span class="badge badge-relationship">{{ $task->clientGroup->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if ($task->clientGroup)
                                    {{ $task->clientGroup->business_name ?? '' }}
                                @endif
                            </td>
                            <td>
                                @if ($task->client)
                                    <span class="badge badge-relationship">{{ $task->client->name ?? '' }}</span>
                                @endif
                            </td> --}}
                            <td>
                                @if ($task->clientBranch)
                                    <span class="badge badge-relationship">{{ $task->clientBranch->name ?? '' }}</span>
                                @endif
                            </td>
                            {{-- <td>
                                {{ $task->call_type_label }}
                            </td>
                            <td>
                                {{ $task->incode }}
                            </td> --}}
                            <td>
                                <div class="flex justify-end">
                                    {{-- @can('task_show') --}}
                                    <a class="btn btn-sm btn-info mr-2" href="{{ route('co.tasks.show', $task) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                    {{-- @endcan --}}
                                    {{-- @can('task_edit') --}}
                                    <a class="btn btn-sm btn-success mr-2" href="{{ route('co.tasks.edit', $task) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                    {{-- @endcan --}}
                                    {{-- @can('task_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $task->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan --}}
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if ($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $tasks->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
            if (!confirm("{{ trans('global.areYouSure') }}")) {
                return
            }
            @this[e.callback](...e.argv)
        })
    </script>
@endpush
