<div wire:submit.prevent="submit" class="p-3">

    <div class="grid grid-cols-5 gap-2 p-1">

        {{-- <div class="form-group {{ $errors->has('employeeAttendanceLog.fin_yr_id') ? 'invalid' : '' }}">
            <label class="form-label" for="fin_yr">{{ trans('cruds.employeeAttendanceLog.fields.fin_yr') }}</label>
            <x-select-list class="form-control" id="fin_yr" name="fin_yr" :options="$this->listsForFields['fin_yr']" wire:model="employeeAttendanceLog.fin_yr_id" />
            <div class="validation-message">
                {{ $errors->first('employeeAttendanceLog.fin_yr_id') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.employeeAttendanceLog.fields.fin_yr_helper') }}
            </div>
        </div> --}}
        <div class="form-group {{ $errors->has('state.year') ? 'invalid' : '' }}">
            <label class="form-label required">Year</label>
            <x-select-list class="form-control" id="year" name="year" :options="$this->listsForFields['year']" wire:model="state.year" />
            <div class="validation-message">
                {{ $errors->first('state.year') }}
            </div>
            <div class="help-block">

            </div>
        </div>
        <div class="form-group {{ $errors->has('state.month') ? 'invalid' : '' }}">
            <label class="form-label required">Month</label>
            <x-select-list class="form-control" id="month" name="month" :options="$this->listsForFields['month']"
                wire:model="state.month" />
            <div class="validation-message">
                {{ $errors->first('state.month') }}
            </div>
            <div class="help-block">

            </div>
        </div>
        <div class="col-span-2"></div>
        <div class="grid form-group place-content-center">
            <button class=" btn btn-primary {{ $this->is_searchable ? '' : ' disabled opacity-50' }}" type="button"
                wire:click="generateReport" @if (!$this->is_searchable) disabled @endif>Search</button>
        </div>

    </div>

    @if ($isReportGenerated)
        <div class="p-1 w-full">
            <iframe src="{{$reportUrl}}" frameborder="0" class="w-full aspect-[11.67/8.27]"></iframe>
        </div>
    @endif

    @if (false)
        {{-- <pre>@json($this->state)</pre> --}}
        <div class="p-2 overflow-x-auto">
            {{-- start date: @json($this->start_date) <br> --}}
            {{-- end date: @json($this->end_date) <br> --}}
            {{-- <pre>@json($ddtt, JSON_PRETTY_PRINT)</pre> --}}
            {{-- @if (!$this->is_searchable)
        @endif --}}
            <table class="text-sm table-bordered w-[2000px]" border="1">
                <thead>
                    <tr>
                        <th class="text-center p-1" rowspan="2">NO</th>
                        <th class="text-center p-1" rowspan="2">EMPLOYEE NAME</th>
                        <th class="text-center p-1" rowspan="2">EMPLOYEE CODE</th>
                        @foreach ($daysInMonth as $day)
                            <th @class(['text-center', 'p-1', 'holiday-class' => $day['is_holiday']])>
                                {{ $day['day'] }}
                            </th>
                        @endforeach
                        <th class="text-center p-1" rowspan="2">PRESENT</th>
                        <th class="text-center p-1" rowspan="2">ABSENT</th>
                        <th class="text-center p-1" rowspan="2">LEAVE</th>
                        <th class="text-center p-1" rowspan="2">LATE</th>
                        <th class="text-center p-1" rowspan="2">HOLIDAY</th>
                    </tr>
                    <tr>
                        {{-- <th></th>
                    <th></th>
                    <th></th> --}}
                        @foreach ($daysInMonth as $day)
                            <th @class([
                                'text-center',
                                'p-1',
                                'uppercase',
                                'holiday-class' => $day['is_holiday'],
                            ])>
                                {{ $day['day_code'] }}</th>
                        @endforeach
                        {{-- <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th> --}}
                    </tr>
                </thead>
                <tbody>
                    @foreach ($employeeData as $key => $employee)
                        <tr>
                            <td class="text-center p-1">{{ $key + 1 }}</td>
                            <td class="text-center p-1">{{ $employee['name'] }}</td>
                            <td class="text-center p-1">{{ $employee['employee_code'] }}</td>
                            @foreach ($daysInMonth as $day => $dayOb)
                                <td @class([
                                    'text-center',
                                    'p-1',
                                    'holiday-class' => $employee['days'][$dayOb['day']]['status_code'] == 'H',
                                    'absent-class text-white' =>
                                        $employee['days'][$dayOb['day']]['status_code'] == 'A',
                                    'present-class text-white' =>
                                        $employee['days'][$dayOb['day']]['status_code'] == 'P',
                                    'leave-class text-white' =>
                                        $employee['days'][$dayOb['day']]['status_code'] == 'L',
                                ])>
                                    {{ $employee['days'][$dayOb['day']]['status_code'] ?? '' }}
                                </td>
                                {{-- <td class="text-center p-1">{{ $day }}</td> --}}
                            @endforeach

                            <td class="text-center p-1">{{ $employee['counts']['present'] }}</td>
                            <td class="text-center p-1">{{ $employee['counts']['absent'] }}</td>
                            <td class="text-center p-1">{{ $employee['counts']['leave'] }}</td>
                            <td class="text-center p-1">{{ $employee['counts']['late'] }}</td>
                            <td class="text-center p-1">{{ $employee['counts']['holiday'] }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endif
</div>

@push('scripts')
    <style>
    </style>
@endpush
