<div>
    <div class="w-full">
        @if (isset($attributes['multiple']))
            <div id="{{ $attributes['id'] }}-btn-container" class="mb-3">
                <button type="button"
                    class="btn btn-info btn-sm select-all-button">{{ trans('global.select_all') }}</button>
                <button type="button"
                    class="btn btn-info btn-sm deselect-all-button">{{ trans('global.deselect_all') }}</button>
            </div>
        @endif

        <select class="select2 form-control" data-placeholder="{{ __('Select your option') }}" {{ $attributes }}>
            @if (!isset($attributes['multiple']))
                <option></option>
            @endif
            @foreach ($options as $key => $value)

                <option value="{{ $isAssoc?$key:$value }}">{{ $value }}</option>
            @endforeach
        </select>
        <div class="select2_container_main" id="{{ $attributes['id'] }}-select2-container-main" wire:ignore>

        </div>
    </div>
</div>

@push('scripts')
    <script>
        window.lwSelect2 = window.lwSelect2 ?? {};

        document.addEventListener("livewire:load", () => {
            let el = $('#{{ $attributes['id'] }}')
            let buttonsId = '#{{ $attributes['id'] }}-btn-container'
            let container = $('#{{ $attributes['id'] }}-select2-container-main')
            lwSelect2['{{ $attributes['id'] }}'] = el;

            function initButtons() {
                $(buttonsId + ' .select-all-button').click(function(e) {
                    el.val(_.map(el.find('option'), opt => $(opt).attr('value')))
                    el.trigger('change')
                })

                $(buttonsId + ' .deselect-all-button').click(function(e) {
                    el.val([])
                    el.trigger('change')
                })
            }

            function initSelect(re = false) {
                // console.log(el);
                initButtons()
                if (re) {
                    try {
                        el.select2('destroy');
                    } catch (error) {
                        console.log('nothing to destroy');
                    }
                }
                el.select2({
                    placeholder: '{{ __('Select your option') }}',
                    allowClear: !el.attr('required'),
                    dropdownParent: container,
                })
            }

            initSelect()

            Livewire.hook('message.processed', (message, component) => {
                initSelect(true)
            });

            el.on('change', function(e) {
                let data = $(this).select2("val")
                if (data === "") {
                    data = null
                }
                @this.set('{{ $attributes['wire:model'] }}', data)
            });
        });
    </script>
@endpush
