@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.specialPlannedDay.title_singular') }}:
                    {{ trans('cruds.specialPlannedDay.fields.id') }}
                    {{ $specialPlannedDay->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.specialPlannedDay.fields.id') }}
                            </th>
                            <td>
                                {{ $specialPlannedDay->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.specialPlannedDay.fields.title') }}
                            </th>
                            <td>
                                {{ $specialPlannedDay->title }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.specialPlannedDay.fields.description') }}
                            </th>
                            <td>
                                {{ $specialPlannedDay->description }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.specialPlannedDay.fields.leave_type') }}
                            </th>
                            <td>
                                {{ $specialPlannedDay->leave_type_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.specialPlannedDay.fields.from_date') }}
                            </th>
                            <td>
                                {{ $specialPlannedDay->from_date }}
                            </td>
                        </tr>
                        {{-- <tr>
                            <th>
                                {{ trans('cruds.specialPlannedDay.fields.to_date') }}
                            </th>
                            <td>
                                {{ $specialPlannedDay->to_date }}
                            </td>
                        </tr> --}}
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('special_planned_day_edit')
                    <a href="{{ route('admin.special-planned-days.edit', $specialPlannedDay) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.special-planned-days.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
