@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.service.title_singular') }}:
                    {{ trans('cruds.service.fields.id') }}
                    {{ $service->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.service.fields.id') }}
                            </th>
                            <td>
                                {{ $service->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.service.fields.name') }}
                            </th>
                            <td>
                                {{ $service->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.service.fields.description') }}
                            </th>
                            <td>
                                {{ $service->description }}
                            </td>
                        </tr>
                        <tr>
                            <th>{{ trans('cruds.service.fields.hsn_code') }}</th>
                            <td>{{ $service->hsn_code }}</td>
                        </tr>
                        <tr>
                            <th>{{ trans('cruds.service.fields.gst_rate') }}</th>
                            <td>{{ $service->gst_rate }}</td>
                        </tr>
                        <tr>
                            <th>{{ trans('cruds.service.fields.cgst_rate') }}</th>
                            <td>{{ $service->cgst_rate }}</td>
                        </tr>
                        <tr>
                            <th>{{ trans('cruds.service.fields.sgst_rate') }}</th>
                            <td>{{ $service->sgst_rate }}</td>
                        </tr>
                        <tr>
                            <th>{{ trans('cruds.service.fields.igst_rate') }}</th>
                            <td>{{ $service->igst_rate }}</td>
                        </tr>
                        <tr>
                            <th>{{ trans('cruds.service.fields.taxable_price') }}</th>
                            <td>{{ $service->taxable_price }}</td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.service.fields.price') }}
                            </th>
                            <td>
                                {{ $service->price }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('service_edit')
                    <a href="{{ route('admin.services.edit', $service) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.services.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
