@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.productZonePivot.title_singular') }}:
                    {{ trans('cruds.productZonePivot.fields.id') }}
                    {{ $productZonePivot->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.productZonePivot.fields.id') }}
                            </th>
                            <td>
                                {{ $productZonePivot->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productZonePivot.fields.product') }}
                            </th>
                            <td>
                                @if($productZonePivot->product)
                                    <span class="badge badge-relationship">{{ $productZonePivot->product->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productZonePivot.fields.zone') }}
                            </th>
                            <td>
                                @if($productZonePivot->zone)
                                    <span class="badge badge-relationship">{{ $productZonePivot->zone->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productZonePivot.fields.quantity') }}
                            </th>
                            <td>
                                {{ $productZonePivot->quantity }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productZonePivot.fields.price') }}
                            </th>
                            <td>
                                {{ $productZonePivot->price }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productZonePivot.fields.last_updated_by') }}
                            </th>
                            <td>
                                @if($productZonePivot->lastUpdatedBy)
                                    <span class="badge badge-relationship">{{ $productZonePivot->lastUpdatedBy->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('product_zone_pivot_edit')
                    <a href="{{ route('admin.product-zone-pivots.edit', $productZonePivot) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.product-zone-pivots.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection