@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.productTaskEventLog.title_singular') }}:
                    {{ trans('cruds.productTaskEventLog.fields.id') }}
                    {{ $productTaskEventLog->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.productTaskEventLog.fields.id') }}
                            </th>
                            <td>
                                {{ $productTaskEventLog->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productTaskEventLog.fields.task_event_log') }}
                            </th>
                            <td>
                                @if($productTaskEventLog->taskEventLog)
                                    <span class="badge badge-relationship">{{ $productTaskEventLog->taskEventLog->event_type ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productTaskEventLog.fields.product') }}
                            </th>
                            <td>
                                @if($productTaskEventLog->product)
                                    <span class="badge badge-relationship">{{ $productTaskEventLog->product->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productTaskEventLog.fields.quantity') }}
                            </th>
                            <td>
                                {{ $productTaskEventLog->quantity }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productTaskEventLog.fields.status') }}
                            </th>
                            <td>
                                {{ $productTaskEventLog->status_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productTaskEventLog.fields.approved_by') }}
                            </th>
                            <td>
                                @if($productTaskEventLog->approvedBy)
                                    <span class="badge badge-relationship">{{ $productTaskEventLog->approvedBy->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.productTaskEventLog.fields.approved_at') }}
                            </th>
                            <td>
                                {{ $productTaskEventLog->approved_at }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('product_task_event_log_edit')
                    <a href="{{ route('admin.product-task-event-logs.edit', $productTaskEventLog) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.product-task-event-logs.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection