@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.ledger.title_singular') }}:
                    {{ trans('cruds.ledger.fields.id') }}
                    {{ $ledger->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.ledger.fields.id') }}
                            </th>
                            <td>
                                {{ $ledger->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledger.fields.name') }}
                            </th>
                            <td>
                                {{ $ledger->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledger.fields.description') }}
                            </th>
                            <td>
                                {{ $ledger->description }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledger.fields.ledger_group') }}
                            </th>
                            <td>
                                @if($ledger->ledgerGroup)
                                    <span class="badge badge-relationship">{{ $ledger->ledgerGroup->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('ledger_edit')
                    <a href="{{ route('admin.ledgers.edit', $ledger) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.ledgers.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection