@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.ledgerTransaction.title_singular') }}:
                    {{ trans('cruds.ledgerTransaction.fields.id') }}
                    {{ $ledgerTransaction->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.id') }}
                            </th>
                            <td>
                                {{ $ledgerTransaction->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.fin_yr') }}
                            </th>
                            <td>
                                @if($ledgerTransaction->finYr)
                                    <span class="badge badge-relationship">{{ $ledgerTransaction->finYr->title ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.ledger') }}
                            </th>
                            <td>
                                @if($ledgerTransaction->ledger)
                                    <span class="badge badge-relationship">{{ $ledgerTransaction->ledger->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.date') }}
                            </th>
                            <td>
                                {{ $ledgerTransaction->date }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.amount') }}
                            </th>
                            <td>
                                {{ $ledgerTransaction->amount }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.type') }}
                            </th>
                            <td>
                                {{ $ledgerTransaction->type_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.cr_bal_before') }}
                            </th>
                            <td>
                                {{ $ledgerTransaction->cr_bal_before }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.dr_bal_before') }}
                            </th>
                            <td>
                                {{ $ledgerTransaction->dr_bal_before }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.cr_bal_after') }}
                            </th>
                            <td>
                                {{ $ledgerTransaction->cr_bal_after }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.dr_bal_after') }}
                            </th>
                            <td>
                                {{ $ledgerTransaction->dr_bal_after }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerTransaction.fields.description') }}
                            </th>
                            <td>
                                {{ $ledgerTransaction->description }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('ledger_transaction_edit')
                    <a href="{{ route('admin.ledger-transactions.edit', $ledgerTransaction) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.ledger-transactions.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection