@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.ledgerLgAttributeValue.title_singular') }}:
                    {{ trans('cruds.ledgerLgAttributeValue.fields.id') }}
                    {{ $ledgerLgAttributeValue->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerLgAttributeValue.fields.id') }}
                            </th>
                            <td>
                                {{ $ledgerLgAttributeValue->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerLgAttributeValue.fields.ledger') }}
                            </th>
                            <td>
                                @if($ledgerLgAttributeValue->ledger)
                                    <span class="badge badge-relationship">{{ $ledgerLgAttributeValue->ledger->name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerLgAttributeValue.fields.lg_attribute') }}
                            </th>
                            <td>
                                @if($ledgerLgAttributeValue->lgAttribute)
                                    <span class="badge badge-relationship">{{ $ledgerLgAttributeValue->lgAttribute->title ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerLgAttributeValue.fields.lg_attribute_value') }}
                            </th>
                            <td>
                                @if($ledgerLgAttributeValue->lgAttributeValue)
                                    <span class="badge badge-relationship">{{ $ledgerLgAttributeValue->lgAttributeValue->value ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerLgAttributeValue.fields.value_text') }}
                            </th>
                            <td>
                                {{ $ledgerLgAttributeValue->value_text }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('ledger_lg_attribute_value_edit')
                    <a href="{{ route('admin.ledger-lg-attribute-values.edit', $ledgerLgAttributeValue) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.ledger-lg-attribute-values.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection