@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.ledgerGroup.title_singular') }}:
                    {{ trans('cruds.ledgerGroup.fields.id') }}
                    {{ $ledgerGroup->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerGroup.fields.id') }}
                            </th>
                            <td>
                                {{ $ledgerGroup->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerGroup.fields.name') }}
                            </th>
                            <td>
                                {{ $ledgerGroup->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.ledgerGroup.fields.purpose') }}
                            </th>
                            <td>
                                {{ $ledgerGroup->purpose }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('ledger_group_edit')
                    <a href="{{ route('admin.ledger-groups.edit', $ledgerGroup) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.ledger-groups.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection