@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.jobDesignation.title_singular') }}:
                    {{ trans('cruds.jobDesignation.fields.id') }}
                    {{ $jobDesignation->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.jobDesignation.fields.id') }}
                            </th>
                            <td>
                                {{ $jobDesignation->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.jobDesignation.fields.title') }}
                            </th>
                            <td>
                                {{ $jobDesignation->title }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.jobDesignation.fields.description') }}
                            </th>
                            <td>
                                {{ $jobDesignation->description }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.jobDesignation.fields.basic_salary') }}
                            </th>
                            <td>
                                {{ $jobDesignation->basic_salary }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.jobDesignation.fields.basic_salary_max') }}
                            </th>
                            <td>
                                {{ $jobDesignation->basic_salary_max }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('job_designation_edit')
                    <a href="{{ route('admin.job-designations.edit', $jobDesignation) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.job-designations.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection