@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.finYr.title_singular') }}:
                    {{ trans('cruds.finYr.fields.id') }}
                    {{ $finYr->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.finYr.fields.id') }}
                            </th>
                            <td>
                                {{ $finYr->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.finYr.fields.title') }}
                            </th>
                            <td>
                                {{ $finYr->title }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.finYr.fields.alias') }}
                            </th>
                            <td>
                                {{ $finYr->alias }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.finYr.fields.date_from') }}
                            </th>
                            <td>
                                {{ $finYr->date_from }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.finYr.fields.date_to') }}
                            </th>
                            <td>
                                {{ $finYr->date_to }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('fin_yr_edit')
                    <a href="{{ route('admin.fin-yrs.edit', $finYr) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.fin-yrs.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection