@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.employeeFamilyDetail.title_singular') }}:
                    {{ trans('cruds.employeeFamilyDetail.fields.id') }}
                    {{ $employeeFamilyDetail->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.employeeFamilyDetail.fields.id') }}
                            </th>
                            <td>
                                {{ $employeeFamilyDetail->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeFamilyDetail.fields.employee_info') }}
                            </th>
                            <td>
                                @if($employeeFamilyDetail->employeeInfo)
                                    <span class="badge badge-relationship">{{ $employeeFamilyDetail->employeeInfo->first_name ?? '' }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeFamilyDetail.fields.relation') }}
                            </th>
                            <td>
                                {{ $employeeFamilyDetail->relation_label }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeFamilyDetail.fields.name') }}
                            </th>
                            <td>
                                {{ $employeeFamilyDetail->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeFamilyDetail.fields.is_dependent') }}
                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $employeeFamilyDetail->is_dependent ? 'checked' : '' }}>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeFamilyDetail.fields.profession') }}
                            </th>
                            <td>
                                {{ $employeeFamilyDetail->profession }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeFamilyDetail.fields.office_name_address') }}
                            </th>
                            <td>
                                {{ $employeeFamilyDetail->office_name_address }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.employeeFamilyDetail.fields.office_contact') }}
                            </th>
                            <td>
                                {{ $employeeFamilyDetail->office_contact }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('employee_family_detail_edit')
                    <a href="{{ route('admin.employee-family-details.edit', $employeeFamilyDetail) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.employee-family-details.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection