@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.contentPage.title_singular') }}:
                    {{ trans('cruds.contentPage.fields.id') }}
                    {{ $contentPage->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.contentPage.fields.id') }}
                            </th>
                            <td>
                                {{ $contentPage->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.contentPage.fields.title') }}
                            </th>
                            <td>
                                {{ $contentPage->title }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.contentPage.fields.category') }}
                            </th>
                            <td>
                                @foreach($contentPage->category as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.contentPage.fields.tag') }}
                            </th>
                            <td>
                                @foreach($contentPage->tag as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.contentPage.fields.page_text') }}
                            </th>
                            <td>
                                {{ $contentPage->page_text }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.contentPage.fields.excerpt') }}
                            </th>
                            <td>
                                {{ $contentPage->excerpt }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.contentPage.fields.featured_image') }}
                            </th>
                            <td>
                                @foreach($contentPage->featured_image as $key => $entry)
                                    <a class="link-photo" href="{{ $entry['url'] }}">
                                        <img src="{{ $entry['preview_thumbnail'] }}" alt="{{ $entry['name'] }}" title="{{ $entry['name'] }}">
                                    </a>
                                @endforeach
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('content_page_edit')
                    <a href="{{ route('admin.content-pages.edit', $contentPage) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.content-pages.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection