@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.company.title_singular') }}:
                    {{ trans('cruds.company.fields.id') }}
                    {{ $company->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.id') }}
                            </th>
                            <td>
                                {{ $company->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.name') }}
                            </th>
                            <td>
                                {{ $company->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.mailing_name') }}
                            </th>
                            <td>
                                {{ $company->mailing_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.address_line_one') }}
                            </th>
                            <td>
                                {{ $company->address_line_one }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.address_line_two') }}
                            </th>
                            <td>
                                {{ $company->address_line_two }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.state') }}
                            </th>
                            <td>
                                {{ $company->state }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.city') }}
                            </th>
                            <td>
                                {{ $company->city }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.pin') }}
                            </th>
                            <td>
                                {{ $company->pin }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.phone') }}
                            </th>
                            <td>
                                {{ $company->phone }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.email') }}
                            </th>
                            <td>
                                {{ $company->email }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.mobile') }}
                            </th>
                            <td>
                                {{ $company->mobile }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.fax_no') }}
                            </th>
                            <td>
                                {{ $company->fax_no }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.website') }}
                            </th>
                            <td>
                                {{ $company->website }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.gst_state') }}
                            </th>
                            <td>
                                {{ $company->gst_state }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.registration_type') }}
                            </th>
                            <td>
                                {{ $company->registration_type }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.gstin') }}
                            </th>
                            <td>
                                {{ $company->gstin }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.period_gstr_one') }}
                            </th>
                            <td>
                                {{ $company->period_gstr_one }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.eway_bill_is_applicable') }}
                            </th>
                            <td>
                                {{ $company->eway_bill_is_applicable }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.threshold_limit') }}
                            </th>
                            <td>
                                {{ $company->threshold_limit }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.apply_for_inter_state') }}
                            </th>
                            <td>
                                {{ $company->apply_for_inter_state }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.company.fields.inter_threshold_limit') }}
                            </th>
                            <td>
                                {{ $company->inter_threshold_limit }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('company_edit')
                    <a href="{{ route('admin.companies.edit', $company) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.companies.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection