@extends('layouts.admin')
@section('content')
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    {{ trans('global.view') }}
                    {{ trans('cruds.clientGroup.title_singular') }}:
                    {{ trans('cruds.clientGroup.fields.id') }}
                    {{ $clientGroup->id }}
                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.id') }}
                            </th>
                            <td>
                                {{ $clientGroup->id }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.name') }}
                            </th>
                            <td>
                                {{ $clientGroup->name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.business_name') }}
                            </th>
                            <td>
                                {{ $clientGroup->business_name }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.address') }}
                            </th>
                            <td>
                                {{ $clientGroup->address }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.phone_1') }}
                            </th>
                            <td>
                                {{ $clientGroup->phone_1 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.phone_2') }}
                            </th>
                            <td>
                                {{ $clientGroup->phone_2 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.email_1') }}
                            </th>
                            <td>
                                {{ $clientGroup->email_1 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.email_2') }}
                            </th>
                            <td>
                                {{ $clientGroup->email_2 }}
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.is_active') }}
                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $clientGroup->is_active ? 'checked' : '' }}>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.has_multi_state_business') }}
                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $clientGroup->has_multi_state_business ? 'checked' : '' }}>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.zone') }}
                            </th>
                            <td>
                                @foreach($clientGroup->zone as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.state') }}
                            </th>
                            <td>
                                @foreach($clientGroup->state as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                        </tr>
                        <tr>
                            <th>
                                {{ trans('cruds.clientGroup.fields.circle') }}
                            </th>
                            <td>
                                @foreach($clientGroup->circle as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                @can('client_group_edit')
                    <a href="{{ route('admin.client-groups.edit', $clientGroup) }}" class="btn btn-indigo mr-2">
                        {{ trans('global.edit') }}
                    </a>
                @endcan
                <a href="{{ route('admin.client-groups.index') }}" class="btn btn-secondary">
                    {{ trans('global.back') }}
                </a>
            </div>
        </div>
    </div>
</div>
@endsection