<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddInvoiceRelatedColumnsInTasksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /*
            is_invoiceable
            o_invoice_id
            amount
            amount_w_gst
            amount_wo_gst
            igst_rate
            cgst_rate
            sgst_rate
            igst_amount
            cgst_amount
            sgst_amount
            gst_amount
            gst_details
        */
        Schema::table('tasks', function (Blueprint $table) {
            $table->boolean('is_invoiceable')->default(false);
            $table->unsignedBigInteger('o_invoice_id')->index()->nullable();
            // $table->decimal('amount', 10, 2)->nullable();
            $table->decimal('amount_w_gst', 10, 2)->nullable();
            $table->decimal('amount_wo_gst', 10, 2)->nullable();
            $table->decimal('igst_rate', 10, 2)->nullable();
            $table->decimal('cgst_rate', 10, 2)->nullable();
            $table->decimal('sgst_rate', 10, 2)->nullable();
            $table->decimal('igst_amount', 10, 2)->nullable();
            $table->decimal('cgst_amount', 10, 2)->nullable();
            $table->decimal('sgst_amount', 10, 2)->nullable();
            $table->decimal('gst_amount', 10, 2)->nullable();
            $table->json('gst_details')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tasks', function (Blueprint $table) {

                $table->dropColumn('is_invoiceable');
                $table->dropColumn('o_invoice_id');
                // $table->dropColumn('amount');
                $table->dropColumn('amount_w_gst');
                $table->dropColumn('amount_wo_gst');
                $table->dropColumn('igst_rate');
                $table->dropColumn('cgst_rate');
                $table->dropColumn('sgst_rate');
                $table->dropColumn('igst_amount');
                $table->dropColumn('cgst_amount');
                $table->dropColumn('sgst_amount');
                $table->dropColumn('gst_amount');
                $table->dropColumn('gst_details');
        });
    }
}
