<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductRequisitionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_requisitions', function (Blueprint $table) {
            $table->id();
            $table->nullableMorphs('requested_by');
            $table->nullableMorphs('requested_to');
            $table->nullableMorphs('requested_for');
            $table->nullableMorphs('accepted_by');
            $table->unsignedBigInteger('product_id')->nullable();
            $table->integer('requested_quantity')->nullable();
            $table->integer('sent_quantity')->nullable();
            $table->string('status')->nullable(); //, ['pending', 'sent', 'completed'])->default('pending');
            $table->boolean('p_listed')->nullable()->default(true); // is_product_listed
            $table->json('product_info')->nullable();
            $table->json('info')->nullable();
            $table->json('additional')->nullable();
            $table->dateTime('accepted_at')->nullable();
            $table->unsignedBigInteger('product_task_event_log_id')->nullable();
            $table->unsignedBigInteger('task_event_log_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_requisitions');
    }
}
