<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeMorphsFieldsToOInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('o_invoices', function (Blueprint $table) {
            // nullable morphs
            $table->unsignedBigInteger('invoiced_to_id')->nullable()->change();
            $table->string('invoiced_to_type')->nullable()->change();
            $table->unsignedBigInteger('invoiced_by_id')->nullable()->change();
            $table->string('invoiced_by_type')->nullable()->change();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('o_invoices', function (Blueprint $table) {
            $table->unsignedBigInteger('invoiced_to_id')->change();
            $table->string('invoiced_to_type')->change();
            $table->unsignedBigInteger('invoiced_by_id')->change();
            $table->string('invoiced_by_type')->change();
        });
    }
}
