<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddGstAndHsnFieldsToOInvoiceItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('o_invoice_items', function (Blueprint $table) {

            $table->string('hsn_code')->nullable();
            $table->decimal('taxable_price', 10, 2)->nullable();
            $table->decimal('gst_rate', 5, 2)->nullable();
            $table->decimal('cgst_rate', 5, 2)->nullable();
            $table->decimal('sgst_rate', 5, 2)->nullable();
            $table->decimal('igst_rate', 5, 2)->nullable();

            // gst amounts
            $table->decimal('gst_amount', 10, 2)->nullable();
            $table->decimal('cgst_amount', 10, 2)->nullable();
            $table->decimal('sgst_amount', 10, 2)->nullable();
            $table->decimal('igst_amount', 10, 2)->nullable();



        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('o_invoice_items', function (Blueprint $table) {

            $table->dropColumn('hsn_code');
            $table->dropColumn('taxable_price');
            $table->dropColumn('gst_rate');
            $table->dropColumn('cgst_rate');
            $table->dropColumn('sgst_rate');
            $table->dropColumn('igst_rate');

            // gst amounts
            $table->dropColumn('gst_amount');
            $table->dropColumn('cgst_amount');
            $table->dropColumn('sgst_amount');
            $table->dropColumn('igst_amount');
        });
    }
}
