<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddHsnCodeGstRelatedColumnsInProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('hsn_code')->nullable();
            $table->decimal('gst_rate', 5, 2)->nullable();
            $table->decimal('cgst_rate', 5, 2)->nullable();
            $table->decimal('sgst_rate', 5, 2)->nullable();
            $table->decimal('igst_rate', 5, 2)->nullable();
            $table->decimal('taxable_price', 10, 2)->nullable();
            // $table->decimal('total_price', 10, 2)->nullable();
            // $table->decimal('discount', 10, 2)->nullable();
            // $table->decimal('price', 10, 2)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn('hsn_code');
            $table->dropColumn('gst_rate');
            $table->dropColumn('cgst_rate');
            $table->dropColumn('sgst_rate');
            $table->dropColumn('igst_rate');
            $table->dropColumn('taxable_price');
            // $table->dropColumn('total_price');
            // $table->dropColumn('discount');
            // $table->dropColumn('price');
        });
    }
}
