<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCircleProductHistoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('circle_product_history', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->nullable();
            $table->foreignId('circle_id')->nullable();
            $table->foreignId('updated_by_id')->nullable();
            $table->integer('quantity')->nullable();
            $table->integer('quantity_before')->nullable();
            $table->foreignId('zone_id')->nullable();
            $table->integer('zone_quantity_before')->nullable();

            $table->string('action')->nullable();
            $table->json('additional')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    // public function down()
    // {
    //     Schema::dropIfExists('circle_product_history');
    // }
}
