<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeFamilyDetailsTable extends Migration
{
    public function up()
    {
        Schema::create('employee_family_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('relation')->nullable();
            $table->string('name')->nullable();
            $table->boolean('is_dependent')->default(0)->nullable();
            $table->string('profession')->nullable();
            $table->longText('office_name_address')->nullable();
            $table->string('office_contact')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }
}
