<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRelationshipFieldsToVisitReimbursementsTable extends Migration
{
    public function up()
    {
        Schema::table('visit_reimbursements', function (Blueprint $table) {
            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id', 'user_fk_7576229')->references('id')->on('users');
            $table->unsignedBigInteger('task_id')->nullable();
            $table->foreign('task_id', 'task_fk_7576230')->references('id')->on('tasks');
            $table->unsignedBigInteger('approved_by_id')->nullable();
            $table->foreign('approved_by_id', 'approved_by_fk_7576231')->references('id')->on('users');
            $table->unsignedBigInteger('visit_id')->nullable();
            $table->foreign('visit_id', 'visit_fk_7576234')->references('id')->on('employee_attendance_logs');
        });
    }
}
