<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitRoutesTable extends Migration
{
    public function up()
    {
        Schema::create('visit_routes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('from')->nullable();
            $table->string('to')->nullable();
            $table->float('journey_distance', 15, 2)->nullable();
            $table->decimal('journey_fare', 15, 2)->nullable();
            $table->string('vehicle_type');
            $table->string('journey_type')->nullable();
            $table->longText('note')->nullable();
            $table->decimal('route_cost', 15, 2)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }
}
