<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRelationshipFieldsToTasksTable extends Migration
{
    public function up()
    {
        Schema::table('tasks', function (Blueprint $table) {
            $table->unsignedBigInteger('status_id')->nullable();
            $table->foreign('status_id', 'status_fk_7282013')->references('id')->on('task_statuses');
            $table->unsignedBigInteger('assigned_to_id')->nullable();
            $table->foreign('assigned_to_id', 'assigned_to_fk_7282017')->references('id')->on('users');
            $table->unsignedBigInteger('client_group_id')->nullable();
            $table->foreign('client_group_id', 'client_group_fk_7470288')->references('id')->on('client_groups');
            $table->unsignedBigInteger('client_id')->nullable();
            $table->foreign('client_id', 'client_fk_7470289')->references('id')->on('clients');
            $table->unsignedBigInteger('client_branch_id')->nullable();
            $table->foreign('client_branch_id', 'client_branch_fk_7470290')->references('id')->on('client_branches');
        });
    }
}
