<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompaniesTable extends Migration
{
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->nullable();
            $table->string('mailing_name')->nullable();
            $table->string('address_line_one')->nullable();
            $table->string('address_line_two')->nullable();
            $table->string('state')->nullable();
            $table->string('city')->nullable();
            $table->string('pin')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('mobile')->nullable();
            $table->string('fax_no')->nullable();
            $table->string('website')->nullable();
            $table->string('gst_state')->nullable();
            $table->string('registration_type')->nullable();
            $table->string('gstin')->nullable();
            $table->string('period_gstr_one')->nullable();
            $table->integer('eway_bill_is_applicable')->nullable();
            $table->decimal('threshold_limit', 15, 2)->nullable();
            $table->integer('apply_for_inter_state')->nullable();
            $table->decimal('inter_threshold_limit', 15, 2)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
