<?php

namespace App\View\Components;

use Illuminate\Support\Arr;
use Illuminate\View\Component;

class SelectList extends Component
{
    public $options;
    public $xidp;
    public $isAssoc = true;

    /**
     * Create a new component instance.
     *
     * @param mixed $options
     * @param mixed $id
     */
    public function __construct($options, $xidp = null)
    {
        $this->options = $options;
        $this->isAssoc = Arr::isAssoc($options);

        $this->xidp = $xidp;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|string
     */
    public function render()
    {
        return view('components.select-list');
    }
}
