<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\ImplicitRule;
use Illuminate\Support\Facades\DB;

class UniqueToMultipleFieldsWithIgnore implements ImplicitRule
{
    private string $table;
    private bool $nullCheck = true;
    private $ignore;
    private $fields;

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(string $table, bool $nullCheck, $ignore, ...$fields)
    {
        $this->table = $table;
        $this->nullCheck = $nullCheck;
        $this->fields = $fields;
        $this->ignore = $ignore;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if ($this->nullCheck) {
            if ($value == null) {
                return true;
            }
        }

        $query = DB::table($this->table)
            ->where(function ($query) use ($value) {
                foreach ($this->fields as $field) {
                    $query->orWhere($field, $value);
                }
            });
        if ($this->ignore) {
            $query->where($this->ignore['field'], '<>', $this->ignore['value']);
        }
        $count = $query->count();
        return $count === 0;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The :attribute has already been taken.';
    }

}
