<?php

namespace App\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Str;

class BladeServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {

        Blade::directive('fjson', function ($expression) {
            $encodingOptions = JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT | JSON_PRETTY_PRINT;
            // $encodingOptions = JSON_PRETTY_PRINT;
            $startsWithVariable = $this->doesStartsWithVariable($expression);
            $str = "";
            if ($startsWithVariable) {
                $parts = explode(',', $this->stripParentheses($expression));
                // dump($parts);

                foreach ($parts as $key => $part) {
                    $partName = substr(trim($part), 1);
                    // $partName = "";
                    $str .= "<pre><code>$partName:</code><?php echo json_encode($part,$encodingOptions); ?></pre><br/>
                    ";
                }
            } else {
                $str .= "<pre><?php echo json_encode($expression,$encodingOptions); ?></pre><br/>";
            }
            return $str;
        });
    }


    public function stripParentheses($expression)
    {
        if (Str::startsWith($expression, '(')) {
            $expression = substr($expression, 1, -1);
        }

        return $expression;
    }

    public function doesStartsWithVariable($expression)
    {
        return Str::startsWith(trim($expression), '$');
    }
}
