<?php

namespace App\Observers;

use App\Models\CrmCustomer;
use App\Models\User;
use App\Notifications\DataChangeEmailNotification;
use Notification;

class CrmCustomerObserver
{
    public function created(CrmCustomer $crmCustomer): void
    {
        $payload = [
            'action' => 'created',
            'model'  => sprintf('%s#%s', get_class($crmCustomer), $crmCustomer->id),
            'reason' => auth()->user(),
        ];

        $admins = User::admins()->get();
        try {
            Notification::send($admins, new DataChangeEmailNotification($payload));
        } catch (\Throwable $th) {
               report($th);
            //throw $th;
        }
    }

    public function updated(CrmCustomer $crmCustomer): void
    {
        $payload = [
            'action' => 'updated',
            'model'  => sprintf('%s#%s', get_class($crmCustomer), $crmCustomer->id),
            'reason' => auth()->user(),
        ];

        $admins = User::admins()->get();

        // Notification::send($admins, new DataChangeEmailNotification($payload));
        try {
            Notification::send($admins, new DataChangeEmailNotification($payload));
        } catch (\Throwable $th) {
               report($th);
            //throw $th;
        }
    }

    public function deleted(CrmCustomer $crmCustomer): void
    {
        $payload = [
            'action' => 'deleted',
            'model'  => sprintf('%s#%s', get_class($crmCustomer), $crmCustomer->id),
            'reason' => auth()->user(),
        ];

        $admins = User::admins()->get();
        try {
            Notification::send($admins, new DataChangeEmailNotification($payload));
        } catch (\Throwable $th) {
               report($th);
            //throw $th;
        }
    }
}
