<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Zone extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public $table = 'zones';

    public $filterable = [
        'id',
        'name',
    ];

    public $orderable = [
        'id',
        'name',
        'is_active',
        'zonal_officer_id',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    protected $fillable = [
        'name',
        'is_active',
        'zonal_officer_id',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    // public function states()
    // {
    //     return $this->hasMany(State::class);
    // }

    public function state()
    {
        return $this->belongsTo(State::class);
    }


    public function circles()
    {
        return $this->hasMany(Circle::class);
    }

    // belongsTo user (zonal_officer)
    public function zonal_officer()
    {
        return $this->belongsTo(User::class, 'zonal_officer_id');
    }

    // productZonePivot
    public function productZonePivots()
    {
        return $this->hasMany(ProductZonePivot::class);
    }

    // belongsToMany products
    public function products()
    {
        return $this->belongsToMany(Product::class, 'product_zone_pivots')

            ->withPivot(['quantity', 'price']);
    }


    /**
     * Get the product requisitions for the circle.
     */
    public function productRequestedToMe()
    {
        return $this->morphMany(ProductRequisition::class, 'requested_to');
    }

    /**
     * Get the product requisitions for the circle.
     */
    public function productRequestedForMe()
    {
        return $this->morphMany(ProductRequisition::class, 'requested_for');
    }
}
