<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SpecialPlannedDay extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public const LEAVE_TYPE_RADIO = [
        'holiday' => 'Holiday',
        // 'halfday' => 'Halfday',
    ];

    public $table = 'special_planned_days';

    public $orderable = [
        'id',
        'title',
        'description',
        'leave_type',
        'from_date',
        'to_date',
    ];

    public $filterable = [
        'id',
        'title',
        'description',
        'leave_type',
        'from_date',
        'to_date',
    ];

    protected $fillable = [
        'title',
        'description',
        'leave_type',
        'from_date',
        'to_date',
    ];

    protected $dates = [
        'from_date',
        'to_date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function getLeaveTypeLabelAttribute($value)
    {
        return static::LEAVE_TYPE_RADIO[$this->leave_type] ?? null;
    }

    public function getFromDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('project.date_format')) : null;
    }

    public function setFromDateAttribute($value)
    {
        $this->attributes['from_date'] = $value ? Carbon::createFromFormat(config('project.date_format'), $value)->format('Y-m-d') : null;
    }

    public function getToDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('project.date_format')) : null;
    }

    public function setToDateAttribute($value)
    {
        $this->attributes['to_date'] = $value ? Carbon::createFromFormat(config('project.date_format'), $value)->format('Y-m-d') : null;
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
