<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Purchase extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public const PARTY_AC_SELECT = [
    ];

    public $table = 'purchases';

    public $orderable = [
        'id',
        'suply_invc_no',
        'prchs_date',
        'party_ac',
        'total_invoic',
        'csgt_amt',
        'sgst_amt',
        'igst_amt',
        'invoice_total_wo_tax',
        'details',
    ];

    public $filterable = [
        'id',
        'suply_invc_no',
        'prchs_date',
        'party_ac',
        'total_invoic',
        'csgt_amt',
        'sgst_amt',
        'igst_amt',
        'invoice_total_wo_tax',
        'details',
    ];

    protected $dates = [
        'prchs_date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'suply_invc_no',
        'prchs_date',
        'party_ac',
        'total_invoic',
        'csgt_amt',
        'sgst_amt',
        'igst_amt',
        'invoice_total_wo_tax',
        'details',
    ];

    public function getPrchsDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('project.date_format')) : null;
    }

    public function setPrchsDateAttribute($value)
    {
        $this->attributes['prchs_date'] = $value ? Carbon::createFromFormat(config('project.date_format'), $value)->format('Y-m-d') : null;
    }

    public function getPartyAcLabelAttribute($value)
    {
        return static::PARTY_AC_SELECT[$this->party_ac] ?? null;
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
