<?php

namespace App\Models;

use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OInvoiceItem extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;


    protected $fillable = [

        'id', 'o_invoice_id', 'name', 'description', 'price', 'quantity', 'is_taxable', 'discount', 'subtotal', 'total',
        'tax_amount', 'tax_perc', 'type', 'extras', 'additional', 'tax_infos', 'invoiceable_type', 'invoiceable_id',
        // 'created_at', 'updated_at', 'deleted_at',
        'hsn_code', 'taxable_price', 'gst_rate', 'cgst_rate', 'sgst_rate', 'igst_rate',
        'gst_amount', 'cgst_amount', 'sgst_amount', 'igst_amount'
    ];

    protected $casts = [
        'is_taxable' => 'boolean',
        'extras' => 'array',
        'additional' => 'array',
        'tax_infos' => 'array',
    ];

    public function invoiceable()
    {
        return $this->morphTo();
    }

    public function o_invoice()
    {
        return $this->belongsTo(OInvoice::class);
    }
    public function invoice()
    {
        return $this->o_invoice();
    }

    public function isProduct()
    {
        return $this->invoiceable_type == Product::class;
    }

    public function isService()
    {
        return $this->invoiceable_type == Service::class;
    }

    public function isTask()
    {
        return $this->invoiceable_type == Task::class;
    }

    public function isOther()
    {
        return $this->invoiceable_type == null;
    }
}
