<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LgAttributeValue extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public $table = 'lg_attribute_values';

    public $orderable = [
        'id',
        'ledger_group_attribute.title',
        'value',
        'so',
    ];

    public $filterable = [
        'id',
        'ledger_group_attribute.title',
        'value',
        'so',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'ledger_group_attribute_id',
        'value',
        'so',
    ];

    public function ledgerGroupAttribute()
    {
        return $this->belongsTo(LgAttribute::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
