<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LgAttribute extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public const TYPE_RADIO = [
        'text'     => 'Text',
        'dropdown' => 'Dropdown',
        'radio'    => 'Radio',
        'checkbox' => 'Checkbox',
    ];

    public $table = 'lg_attributes';

    public $filterable = [
        'id',
        'title',
        'description',
        'type',
        'ledger_group.name',
    ];

    public $orderable = [
        'id',
        'title',
        'description',
        'is_active',
        'type',
        'ledger_group.name',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'title',
        'description',
        'is_active',
        'type',
        'ledger_group_id',
    ];

    public function getTypeLabelAttribute($value)
    {
        return static::TYPE_RADIO[$this->type] ?? null;
    }

    public function ledgerGroup()
    {
        return $this->belongsTo(LedgerGroup::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
    public function ledgerattrvalues()
    {
        return $this->hasMany(LgAttributeValue::class, 'ledger_group_attribute_id');
    }
}
