<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LedgerLgAttributeValue extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public $table = 'ledger_lg_attribute_values';

    public $orderable = [
        'id',
        'ledger.name',
        'lg_attribute.title',
        'lg_attribute_value.value',
        'value_text',
    ];

    public $filterable = [
        'id',
        'ledger.name',
        'lg_attribute.title',
        'lg_attribute_value.value',
        'value_text',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'ledger_id',
        'lg_attribute_id',
        'lg_attribute_value_id',
        'value_text',
    ];

    public function ledger()
    {
        return $this->belongsTo(Ledger::class);
    }

    public function lgAttribute()
    {
        return $this->belongsTo(LgAttribute::class);
    }

    public function lgAttributeValue()
    {
        return $this->belongsTo(LgAttributeValue::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
