<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KVSetting extends Model
{
    use HasFactory;



    protected $fillable = ['key', 'value'];

    public const  KEY_APP_VERSION = "app.version";
    public const  KEY_APP_VERSION_MINOR_MANDATORY = "app.version.minor-mandatory";
    public const  KEY_APP_MAINTENANCE_MODE = "app.is_maintenance";
    public const  KEY_WEEKLY_HOLIDAY_MODE = "core.weekly-holiday-mode";





    // vals
    public const  VAL_WEEKLY_HOLIDAY_MODE_SUN = "sunday";
    public const  VAL_WEEKLY_HOLIDAY_MODE_SAT = "saturday";
    public const  VAL_WEEKLY_HOLIDAY_MODE_SAT_SUN = "sat-sun";
    public const  VAL_WEEKLY_HOLIDAY_MODE_SAT_HALF_SUN = "sat-half-sun-full";
    public const  VAL_WEEKLY_HOLIDAY_MODE_1ST_3RD_SAT_SUN = "1-3-sat-sun";
    public const  VAL_WEEKLY_HOLIDAY_MODE_2ND_4TH_SAT_SUN = "2-4-sat-sun";


    public static $holidayModes = [
        'sunday'                =>      'Sunday',
        'saturday'              =>      'Saturday',
        'sat-sun'               =>      'Saturday,Sunday',
        'sat-half-sun-full'     =>      'Saturday Half Day,Sunday',
        '1-3-sat-sun'           =>      '1st & 3rd Saturday, Sunday',
        '2-4-sat-sun'           =>      '2nd & 4th Saturday, Sunday',
    ];



    public static function Get(string $key, $default = null)
    {
        $ob = self::query()->where('key', $key)->first();
        // dd($ob);
        return $ob ? $ob->value : $default;
    }

    public static function Set(string $key, $value)
    {
        $ob = self::query()->where('key', $key)->first();
        if ($ob) {
            return $ob->update([
                'value' => $value
            ]);
        } else {
            return self::create(['key' => $key, 'value' => $value]) ? true : false;
        }
        return false;
    }




    public static function getAppVersion()
    {
        $g = self::Get(self::KEY_APP_VERSION);
        return $g; //? (string)$g->value : null;
    }
    public static function setAppVersion(string $value)
    {
        return self::Set(self::KEY_APP_VERSION, $value);
    }
    public static function getAppVersionMinorMandatory()
    {
        $g = self::Get(self::KEY_APP_VERSION_MINOR_MANDATORY);
        return $g; //? (string)$g->value : null;
    }
    public static function setAppVersionMinorMandatory(string $value)
    {
        return self::Set(self::KEY_APP_VERSION_MINOR_MANDATORY, $value);
    }

    public static function getAppIsMaintenance()
    {
        $g = self::Get(self::KEY_APP_MAINTENANCE_MODE);
        return (boolval($g));
    }
    public static function setAppIsMaintenance(bool $value)
    {
        return self::Set(self::KEY_APP_MAINTENANCE_MODE, $value);
    }

    //
    public static function getWeeklyHolidayMode()
    {
        $g = self::Get(self::KEY_WEEKLY_HOLIDAY_MODE);
        return ($g);
    }
    //
    public static function setWeeklyHolidayMode($value)
    {
        return self::Set(self::KEY_WEEKLY_HOLIDAY_MODE, $value);
    }


    // get & set settings.ota-update-url
    public static function getOtaUpdateUrl()
    {
        $g = self::Get('settings.ota-update-url');
        return $g; // (string)$g->value : null;
    }
    public static function setOtaUpdateUrl(string $value)
    {
        return self::Set('settings.ota-update-url', $value);
    }

    // get & set settings.ota-update-version
    public static function getOtaUpdateVersion()
    {
        $g = self::Get('settings.ota-update-version');
        return $g; // (string)$g->value : null;
    }
    public static function setOtaUpdateVersion(string $value)
    {
        return self::Set('settings.ota-update-version', $value);
    }

    // get & set settings.ota-update-enabled-for-prod
    public static function getOtaUpdateEnabledForProd()
    {
        $g = self::Get('settings.ota-update-enabled-for-prod');
        return  (bool)($g->value ? $g->value : null);
    }
    public static function setOtaUpdateEnabledForProd(string $value)
    {
        return self::Set('settings.ota-update-enabled-for-prod', $value);
    }

    // get & set settings.payroll-formula-variables
    public static function getPayrollFormulaVariables()
    {
        $g = self::Get('settings.payroll-formula-variables');
        return json_decode($g, true) ?? []; // (string)$g->value : null;
    }
    public static function setPayrollFormulaVariables(array $value)
    {
        return self::Set('settings.payroll-formula-variables', json_encode($value));
    }

    // get & set settings.invoice.prefix
    public static function getInvoicePrefix()
    {
        return cache()->rememberForever('settings.invoice.prefix', function () {
            // return KVSetting::getInvoicePrefix();
            $g = self::Get('settings.invoice.prefix');
            return json_decode($g); // (string)$g->value : null;
        });
    }
    public static function setInvoicePrefix(string $value)
    {
        cache()->forget('settings.invoice.prefix');
        return self::Set('settings.invoice.prefix', json_encode($value));
    }

    // get & set settings.invoice.last-slno
    public static function getInvoiceLastSlno()
    {
        $g = self::Get('settings.invoice.last-slno');
        return intval($g ?? 1); // (string)$g->value : null;
    }
    public static function setInvoiceLastSlno($value)
    {
        return self::Set('settings.invoice.last-slno', intval($value));
    }

    // get next slno
    public static function getNextInvoiceSlno()
    {
        $slno = self::getInvoiceLastSlno();
        $slnoNext = $slno + 1;
        self::setInvoiceLastSlno($slnoNext);
        return $slno;
    }



    public static function KVSettingSeeder()
    {
        if (!self::getWeeklyHolidayMode()) {
            self::setWeeklyHolidayMode(self::VAL_WEEKLY_HOLIDAY_MODE_SAT_SUN);
        }
    }
}
