<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FinYr extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public $table = 'fin_yrs';

    public $orderable = [
        'id',
        'title',
        'alias',
        'date_from',
        'date_to',
    ];

    public $filterable = [
        'id',
        'title',
        'alias',
        'date_from',
        'date_to',
    ];

    protected $fillable = [
        'title',
        'alias',
        'date_from',
        'date_to',
    ];

    protected $dates = [
        'date_from',
        'date_to',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function getDateFromAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('project.date_format')) : null;
    }

    public function setDateFromAttribute($value)
    {
        $this->attributes['date_from'] = $value ? Carbon::createFromFormat(config('project.date_format'), $value)->format('Y-m-d') : null;
    }

    public function getDateToAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('project.date_format')) : null;
    }

    public function setDateToAttribute($value)
    {
        $this->attributes['date_to'] = $value ? Carbon::createFromFormat(config('project.date_format'), $value)->format('Y-m-d') : null;
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }


    public function getFinMonths()
    {
        $finMonths = [];
        $dateFrom = Carbon::parse($this->date_from);
        $dateTo = Carbon::parse($this->date_to);
        $fmtKey = "n:Y";
        $fmt = "M, Y";
        $finMStrKey = $dateFrom->format($fmtKey);
        $finMStr = $dateFrom->format($fmt);
        $finMonths[$finMStrKey] = $finMStr;
        while ($dateFrom->addMonth() <= $dateTo) {
            // $finMonths[] = $dateFrom->format($fmt);
            $finMStrKey = $dateFrom->format($fmtKey);
            $finMStr = $dateFrom->format($fmt);
            $finMonths[$finMStrKey] = $finMStr;
        }
        return $finMonths;
    }
}
