<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeFamilyDetail extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public const RELATION_RADIO = [
        'Spouse' => 'Spouse',
        'Father' => 'Father',
        'Mother' => 'Mother',
        'Child'  => 'Child',
    ];

    public $table = 'employee_family_details';

    public $filterable = [
        'id',
        'employee_info.first_name',
        'relation',
        'name',
        'profession',
        'office_name_address',
        'office_contact',
    ];

    public $orderable = [
        'id',
        'employee_info.first_name',
        'relation',
        'name',
        'is_dependent',
        'profession',
        'office_name_address',
        'office_contact',
    ];

    protected $casts = [
        'is_dependent' => 'boolean',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'employee_info_id',
        'relation',
        'name',
        'is_dependent',
        'profession',
        'office_name_address',
        'office_contact',
    ];

    public function employeeInfo()
    {
        return $this->belongsTo(EmployeeInfo::class);
    }

    public function getRelationLabelAttribute($value)
    {
        return static::RELATION_RADIO[$this->relation] ?? null;
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
