<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;
    use Auditable;

    public const GST_REG_TYPE_SELECT = [
        'reqular'      => 'Regular',
        'exempted'     => 'Exempted',
        'unregistered' => 'UnRegistered',
        'composite'    => 'Composite',
    ];

    public $table = 'clients';

    public $filterable = [
        'id',
        'client_group.business_name',
        'client_group.name',
        'state.name',
        'name',
        'rhq_address',
        'rhq_phone',
        'rhq_email',
        'gstin',
        'gst_reg_type',
    ];

    public $orderable = [
        'id',
        'client_group.business_name',
        'client_group.name',
        'state.name',
        'name',
        'rhq_address',
        'rhq_phone',
        'rhq_email',
        'gstin',
        'gst_reg_type',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'client_group_id',
        'state_id',
        'name',
        'rhq_address',
        'rhq_phone',
        'rhq_email',
        'gstin',
        'gst_reg_type',
        'is_active',
    ];

    public function clientGroup()
    {
        return $this->belongsTo(ClientGroup::class);
    }
    public function clientBranches()
    {
        return $this->hasMany(ClientBranch::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function getGstRegTypeLabelAttribute($value)
    {
        return static::GST_REG_TYPE_SELECT[$this->gst_reg_type] ?? null;
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
