<?php

namespace App\Models;

use \DateTimeInterface;
use App\Support\HasAdvancedFilter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CircleProductPivot extends Model
{
    use HasFactory;
    use HasAdvancedFilter;
    use SoftDeletes;

    public $table = 'circle_product_pivots';

    public $orderable = [
        'id',
        'product.name',
        'circle.name',
        'quantity',
        'price',
        'last_updated_by.name',
    ];

    public $filterable = [
        'id',
        'product.name',
        'circle.name',
        'quantity',
        'price',
        'last_updated_by.name',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'product_id',
        'circle_id',
        'quantity',
        'price',
        'last_updated_by_id',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function circle()
    {
        return $this->belongsTo(Circle::class);
    }

    public function lastUpdatedBy()
    {
        return $this->belongsTo(User::class);
    }

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
