<?php

namespace App\Http\Requests;

use App\Models\Region;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateRegionRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('region_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'string',
                'nullable',
            ],
            'is_active' => [
                'boolean',
            ],
            'circle_id' => [
                'integer',
                'exists:circles,id',
                'nullable',
            ],
            'engineer' => [
                'array',
            ],
            'engineer.*.id' => [
                'integer',
                'exists:users,id',
            ],
        ];
    }
}
