<?php

namespace App\Http\Requests;

use App\Models\MonthlyPayslip;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateMonthlyPayslipRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('monthly_payslip_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'fin_yr_id' => [
                'integer',
                'exists:fin_yrs,id',
                'nullable',
            ],
            'year' => [
                'required',
                'in:' . implode(',', array_keys(MonthlyPayslip::YEAR_SELECT)),
            ],
            'month' => [
                'required',
                'in:' . implode(',', array_keys(MonthlyPayslip::MONTH_SELECT)),
            ],
            'user_id' => [
                'integer',
                'exists:users,id',
                'nullable',
            ],
            'emp_code' => [
                'string',
                'nullable',
            ],
            'location' => [
                'string',
                'nullable',
            ],
            'name' => [
                'string',
                'nullable',
            ],
            'payment_mode' => [
                'string',
                'nullable',
            ],
            'bank' => [
                'string',
                'nullable',
            ],
            'bank_ac_no' => [
                'string',
                'nullable',
            ],
            'aadhaar' => [
                'string',
                'nullable',
            ],
            'blood_group' => [
                'string',
                'nullable',
            ],
            'days_in_month' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'lwp_days' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'working_days' => [
                'integer',
                'min:-2147483648',
                'max:2147483647',
                'nullable',
            ],
            'esic_no' => [
                'string',
                'nullable',
            ],
            'uan' => [
                'string',
                'nullable',
            ],
            'basic_salary' => [
                'numeric',
                'nullable',
            ],
            'hra' => [
                'numeric',
                'nullable',
            ],
            'ta' => [
                'numeric',
                'nullable',
            ],
            'incentive' => [
                'numeric',
                'nullable',
            ],
            'total_earning' => [
                'numeric',
                'nullable',
            ],
            'pf' => [
                'numeric',
                'nullable',
            ],
            'ptax' => [
                'numeric',
                'nullable',
            ],
            'esic' => [
                'numeric',
                'nullable',
            ],
            'total_deduction' => [
                'numeric',
                'nullable',
            ],
            'total_payment' => [
                'string',
                'nullable',
            ],
            'payment_status' => [
                'nullable',
                'in:' . implode(',', array_keys(MonthlyPayslip::PAYMENT_STATUS_SELECT)),
            ],
        ];
    }
}
