<?php

namespace App\Http\Requests;

use App\Models\Client;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateClientRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(
            Gate::denies('client_edit'),
            response()->json(
                ['message' => 'This action is unauthorized.'],
                Response::HTTP_FORBIDDEN
            ),
        );

        return true;
    }

    public function rules(): array
    {
        return [
            'client_group_id' => [
                'integer',
                'exists:client_groups,id',
                'nullable',
            ],
            'state_id' => [
                'integer',
                'exists:states,id',
                'nullable',
            ],
            'name' => [
                'string',
                'nullable',
            ],
            'rhq_address' => [
                'string',
                'nullable',
            ],
            'rhq_phone' => [
                'string',
                'nullable',
            ],
            'rhq_email' => [
                'string',
                'nullable',
            ],
            'gstin' => [
                'string',
                'nullable',
            ],
            'gst_reg_type' => [
                'nullable',
                'in:' . implode(',', array_keys(Client::GST_REG_TYPE_SELECT)),
            ],
            'is_active' => [
                'boolean',
            ],
        ];
    }
}
